/*************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2007, All Rights Reserved   *
*************************************************************************/

/************************************************************************
*                                                                       *
*             EEPROM Emulation Driver for S12XS/S12P                    *
*                                                                       *
* FILE NAME       ee_emulation.h                                        *
* DATE            05.02.2008                                            *
* AUTHOR          Infosys Team, Mysore                                  *
* EMAIL           r56611@freescale.com                                  *
************************************************************************/

/******************************* CHANGES *******************************
 * 0.0a   06.12.2007    Sindhu R01       Initial Version
 * 0.1    08.03.2007    Sindhu R01       Updated to support the
                                         Cosmic compiler
 * 0.2    10.17.2007    Sindhu R01       Added macro
                                         EED_MAX_ERASING_CYCLE_VALUE
 * 1.0    05.02.2008    Sindhu R01       Added the function prototype of
                                         FSL_CheckMarginLevel() and a few
                                         macros to fix partial programming
                                         and dead sector errors
 * 1.1    10.09.2009      Carlos Galuzio   Cleaned up uncessary code to run the AN                                         
 ***********************************************************************/

#ifndef _EE_EMULATION_H_
#define _EE_EMULATION_H_

#include "SSD_Types.h"
#include "SSD_SGF18.h"
#include "SSD_SGF18_Internal.h"


/* structure declaration */
typedef struct
{
    UINT16  dataID;       /* the unique data ID */
    UINT16  dataVal;     /* the data size */
}DATA_RECORD;

#define OFF   0x0
#define ON   0x1

/*****************************************************************************
* User Configurable Macros
*****************************************************************************/

/* Start Address of Flash for EEPROM emulation. */
#if ((SGF18_SELECT == S12XS_64)|(SGF18_SELECT == S12XS_128_256)) /* If S12XS family */

/* For S12XS D-Flash start addr is 0x00100000 */
  #define EED_FLASH_START_ADDRESS       DFLASH_BLOCK_START_ADDR

#else /* If S12P family */

/* For S12P Flash start addr is 0x00004400 */
  #define EED_FLASH_START_ADDRESS       DFLASH_BLOCK_START_ADDR

#endif


/**** End of User Configurable Macros ****/

/* Return code definition */
#define EED_OK                      0x0000
#define EED_ERROR_NOT_BLANK         0x0001
#define EED_ERROR_SIZE              0x0002
#define EED_ERROR_NOFND             0x0003
#define EED_ERROR_RANGE             0x0004
#define EED_ERROR_SSTAT             0x0005
#define EED_ERROR_VERIFY            0x0006
#define EED_ERROR_IDRNG             0x0007
#define EED_ERROR_ACCERR            0x0008
#define EED_ERROR_PVIOL             0x0010
#define EED_ERROR_MGSTAT0           0x0020
#define EED_ERROR_MGSTAT1           0x0040
#define EED_ERROR_INVALIDCLK        0x0800

/* Sector size */
#define EED_SECTOR_SIZE             0x0100


/* End Address of Flash from EEPROM emulation. */
#define EED_FLASH_END_ADDRESS          DFLASH_BLOCK_END_ADDR

/* function declarations */
/* middle level functions */
#pragma CODE_SEG DEFAULT

extern UINT16 FSL_Program (UINT32 destination,UINT16 size,UINT16 sourceData);

#endif /*_EE_EMULATION_H_*/
